#!/bin/sh

# Copyright 2002 Jose Nazario <jose@monkey.org>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# paths
export PATH=$PATH:/usr/local/bin
export MAILTO=empty
FIGS=../figs
TIME=`date +%s`

# old variables
OLDDE0IN=`cat de0in.old`
OLDSIS0IN=`cat sis0in.old`
OLDSIS1IN=`cat sis1in.old`
OLDDE0OUT=`cat de0out.old`
OLDSIS0OUT=`cat sis0out.old`
OLDSIS1OUT=`cat sis1out.old`

# new variables
DE0IN=`netstat -nI de0 | awk '{if ($0 ~ /Link/) print $5}'`
DE0OUT=`netstat -nI de0 | awk '{if ($0 ~ /Link/) print $7}'`
SIS0IN=`netstat -nI sis0 | awk '{if ($0 ~ /Link/) print $5}'`
SIS0OUT=`netstat -nI sis0 | awk '{if ($0 ~ /Link/) print $7}'`
SIS1OUT=`netstat -nI sis1 | awk '{if ($0 ~ /Link/) print $5}'`
SIS1OUT=`netstat -nI sis1 | awk '{if ($0 ~ /Link/) print $7}'`
PFSTATES=`sudo pfctl -s s | wc -l`
ROUTES=`netstat -nrf inet | wc -l`

# differences
de0in=`echo ${DE0IN}-${OLDDE0IN} | bc`
de0out=`echo ${DE0OUT}-${OLDDE0OUT} | bc`
sis0in=`echo ${SIS0IN}-${OLDSIS0IN} | bc`
sis0out=`echo ${SIS0OUT}-${OLDSIS0OUT} | bc`
sis1in=`echo ${SIS1IN}-${OLDSIS1IN} | bc`
sis1out=`echo ${SIS1OUT}-${OLDSIS1OUT} | bc`

echo ${DE0IN} > de0in.old
echo ${SIS0IN} > sis0in.old
echo ${SIS1IN} > sis1in.old
echo ${DE0OUT} > de0out.old
echo ${SIS0OUT} > sis0out.old
echo ${SIS1OUT} > sis1out.old

rm -f data.tmp
cat data > data.tmp
echo "$TIME $PFSTATES $ROUTES $de0in $de0out $sis0in $sis0out $sis1in $sis1out" >> data.tmp
tail -1000 data.tmp > data
rm -f data.tmp

gnuplot < plotme.p && ppmtogif data.ppm > ../figs/graph.gif
gnuplot < plotme-sis0.p && ppmtogif data-sis0.ppm > ../figs/graph-sis0.gif
gnuplot < plotme-sis1.p && ppmtogif data-sis1.ppm > ../figs/graph-sis1.gif
gnuplot < plotme-routes.p && ppmtogif data-routes.ppm > ../figs/graph-routes.gif

# build the html page

cat header > stats.html
sudo pfctl -s r >> stats.html
cat middle >> stats.html
netstat -nrf inet >> stats.html
cat footer >> stats.html
date >> stats.html

mv stats.html ../stats.html
chmod a+r ../stats.html
chmod -R a+r ../figs

# build the intro page
cat arphead > index.html
./genarp.awk /var/arpwatch/arp-sis0.dat >> index.html
cat arpfoot >> index.html
mv index.html ../index.html
chmod a+r ../index.html

# prepare the pf log pages
/home/jose/fw-mon/genall.sh
