#!/usr/bin/awk -f

# Copyright 2002 Jose Nazario <jose@monkey.org>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

BEGIN  {
        print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" \"http://www.w3.org/TR/REC-html40/loose.dtd\">"
        print "<html>"
        print "<head>"
        print "<title>FW Log Summary</title>"
	print "<HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\"> "
        print "<body bgcolor=white>"
	print "<table cellpadding=2 cellspacing=1 border=0 width=\"100%\">"
	print "<tr><td bgcolor=\"#cccccc\"> <font size=-1>"
	print "Navigate: <a href=\"stats.html\">Status</a> | <a href=\"tcp.html\">TCP</a> | <a href=\"udp.html\">UDP </a>"
	print "| <a href=\"icmp.html\">ICMP</a> | <a href=\"other.html\">Other</a>"
	print "</td>"
	print "</tr></table>"
        print "<table cellpadding=5 cellspacing=0 border=0 width=\"100%\">"
	print "<tr><td>"
	print "<strong>Time</strong></td>"
	print "<td><strong>Rule</strong></td>"
	print "<td><strong>Source IP (and port)</strong></td>"
	print "<td><strong>Destination IP (and port)</strong></td>"
	print "<td><strong>IP proto information</strong></td>"
	print "</tr>"
}
{
	# time
	if (NR%2) {
        	print "<tr><td>"
	} else {
		print "<tr><td bgcolor=\"#bbbbbb\">"
	}
	print $1" "$2" "$3

	# rule
	if (NR%2) {
		if ($6 ~ /pass/) {
			print "</td> <td bgcolor=\"#9fc450\">"
		} else {
			print "</td> <td bgcolor=\"#c6004b\">"
		}
	} else {
		if ($6 ~ /pass/) {
                        print "</td> <td bgcolor=\"#699812\">"
                } else {
			print "</td> <td bgcolor=\"#c59898\">"
		}
	}
        print $4" "$5" "$6" "$7" "$8" "$9

	# source IP (and port)
	if (NR%2) {
		print "</td> <td>"
	} else {
		print "</td> <td bgcolor=\"#bbaaff\">"
	}
	print $10 

	# dest IP (and port)
	if (NR%2) {
		print "</td> <td>"
	} else {
		print "</td> <td bgcolor=\"#a7a7a7\">"
	}
	print $12

	# proto into (ie proto name, ttl, flags, size)
	if (NR%2) {
		print "</td> <td>"
	} else {
		print "</td> <td bgcolor=\"#a9a9a9\">"
	}
	print $13" "$14" "$15" "$16" "$17" "$18" "$19" "$20
	print "</td></tr>"

}
END {
	print "</table>"
	print "</body></html>"
}
