#!/usr/bin/awk -f
#
# process.awk
#
# script to process my scanssh (ssh, telnet, rsh) sweep data
#
# (c) 2001 jose nazario     27 oct 01
#
BEGIN { ssh = 0
	telnet = 0
	rsh = 0
	ssh_telnet_rsh = 0
	ssh_telnet = 0
	ssh_rsh = 0
	telnet_rsh = 0 
	up = 0

	openssh = 0
	sshcom = 0
	sshother = 0

	proto13 = 0
	proto15 = 0
	proto199 = 0
	proto2 = 0 
	protoother = 0

	FS= ","

	skip = 0	}

{ if ($2 !~ /Interrupted/)
	up = up+1
  if ($2 ~ /SSH-/)
	ssh=ssh+1
  if ($3 ~ /1/)
	telnet=telnet+1
  if ($4 ~ /1/)
	rsh=rsh+1
  if ( ($2 ~ /SSH-/) && ($3 ~ /1/) && ($4 ~ /1/) ) {
	ssh_telnet_rsh = ssh_telnet_rsh+1
	skip = 1
  }
  if ( ($2 ~ /SSH-/) && ($3 ~ /1/) && (!skip) )
	ssh_telnet = ssh_telnet+1
  if ( ($3 ~ /1/) && ($4 ~ /1/) && (!skip) )
	telnet_rsh = telnet_rsh+1
  if ( ($2 ~ /1/) && ($4 ~ /1/) && (!skip) )
	ssh_rsh = ssh_rsh+1

## 		daemon tallying
  if ($2 ~ /OpenSSH/)
	openssh = openssh + 1
  else if ($2 ~ /SSH-[12]\..*-[123]\./)
	sshcom = sshcom +1
  else if ($2 ~ /SSH/)
	sshother = sshother+1

## 		protocol analysis
  if ($2 ~ /SSH-1.99/)
	proto199 = proto199+1
  else if ($2 ~ /SSH-1.5/)
	proto15 = proto15+1
  else if ($2 ~ /SSH-1.3/)
	proto13 = proto13+1	
  else if ($2 ~ /SSH-2.0/)
	proto2 = proto2+1
  else if ($2 ~ /SSH-/)
	protoother = protoother+1

  skip = 0
}

END {
	printf ("---- ScanSSH Results for 22/23/513 scans -------- \n\n")
	printf ("%-25s\t%10d\n", "number of hosts scanned:", up)
	printf ("%-25s\t%10d\n\n", "number of hosts attempted:", NR)
	printf ("%-25s\t%10d\n", "ssh", ssh)
	printf ("%-25s\t%10d\n", "telnet", telnet)
	printf ("%-25s\t%10d\n", "rsh", rsh)
	printf ("%-25s\t%10d\n", "ssh_telnet_rsh", ssh_telnet_rsh)
	printf ("%-25s\t%10d\n", "ssh_telnet", ssh_telnet)
	printf ("%-25s\t%10d\n", "ssh_rsh", ssh_rsh)
	printf ("%-25s\t%10d\n", "telnet_rsh", telnet_rsh)
	# unanticipated divide by 0 bug  31oct01
	if (up == "0")
	printf ("\n%-25s\t%10d\n", "ssh percentage:", "0")
	else 
	printf ("\n%-25s\t%10d\n", "ssh percentage:", ((ssh/up)*100))

	printf ("\nSSH daemon breakdown ---------------------")
	printf ("\n%-25s\t%10d\n", "OpenSSH", openssh)
	printf ("%-25s\t%10d\n", "SSH.com", sshcom)
	printf ("%-25s\t%10d\n", "Unknown", sshother)

	printf ("\nSSH protocol breakdown -------------------\n")
	printf ("%-25s\t%10d\n", "SSH-2.0", proto2)
	printf ("%-25s\t%10d\n", "SSH-1.99", proto199)
	printf ("%-25s\t%10d\n", "SSH-1.5", proto15)
	printf ("%-25s\t%10d\n", "SSH-1.3", proto13)
	printf ("%-25s\t%10d\n", "Other (legacy, unrecognized)", protoother)
} 
