/* $Id: cli.c,v 1.6 2002/11/19 22:06:09 jnazario Exp $ */

/*
 * Copyright 2002 Jose Nazario <jose@monkey.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <err.h>
#include <errno.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef	__FreeBSD__
#include <libutil.h>
#endif
#ifdef	__OpenBSD__
#include <util.h>
#endif

#include "cli.h"

int
cli_loop(int fdin, int fdout, const char *prompt, cli_handler callback) {
	char		*p;
	FILE		*streamin;
	FILE		*streamout = NULL;
	size_t		 len;

	if ((streamin = fdopen(fdin, "r")) == NULL) {
		warn("Failed to open specified file descriptor");
		return(errno);
	}

	if (fdout > -1)
		if ((streamout = fdopen(fdout, "w+")) == NULL) {
			warn("Failed to open specified file descriptor");
			return(errno);
		}

	for (;;) {
		int             i = 0;
		char            *input, *forward[MAX_TOKENS];

		if (streamout != NULL)
			fprintf(streamout, "%s", prompt);

		if ((input = fparseln(streamin, NULL, NULL, NULL, 0)) == NULL) {
			break;
		}
		
		for (; i < MAX_TOKENS-1 &&
		    (forward[i] = strsep(&input, " \t")) != NULL;)
			if (*forward[i] != '\0')
				i++;

		if (i > 0)
			if (callback (i, forward) < 0)
				return (-1);
		free(input);
	}

	if (streamout != NULL)
		fclose(streamout);
	fclose(streamin);
	return (0);
}

int
vcli_loop(int fdin, int fdout, prompt_handler p_callback, cli_handler callback) {
	char            *p;
	FILE            *streamin;
	FILE            *streamout = NULL;
	size_t           len;
	
	if ((streamin = fdopen(fdin, "r")) == NULL) {
		warn("Failed to open specified file descriptor");
		return(errno);
	}

	if (fdout > -1) 
		if ((streamout = fdopen(fdout, "w+")) == NULL) {
			warn("Failed to open specific file descriptor");
			return(errno);
		}

	for (;;) {
		int 		i = 0;
		char	       *input, *forward[MAX_TOKENS];

		if (streamout != NULL) {
			fprintf(streamout, "%s", p_callback());
		}

		if ((input = fparseln(streamin, NULL, NULL, NULL, 0)) == NULL) {
			break;
		}

		for (; i < MAX_TOKENS-1 &&
		    (forward[i] = strsep(&input, " \t")) != NULL;)
			if (*forward[i] != '\0')
				i++;

		if (i > 0)
			if (callback (i, forward) < 0)
				return (-1);
		free(input);
	}

	if (streamout != NULL)
		fclose(streamout);
	fclose(streamin);
	return(0);
}
