#!/usr/bin/awk -f

#  Copyright 2002 Jose Nazario <jose@monkey.org>
#  All rights reserved.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#
#  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
#  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
#  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# failgen.awk
#
# used to geneated random failures in systrace(1) policies using a configurable
# number of failures. this is useful in fault injection tests where you want
# to observe the error handling of applications. uses a random array of
# error conditions from errno(2). inspired by dugsong.

BEGIN {
	if (ARGC < 3) {
		print "missing argument"
		print "usage: failgen.awk <policy> <percent>"
		print "where <percent> is the percent to fail (0-1)"
		exit
	}
	myrand = int(ARGV[2] * 10)
	delete ARGV[2]

	# set up the errorcode array, from errno(2)
	errcode[1] = "eperm"
	errcode[2] = "enoent"
	errcode[3] = "esrch"
	errcode[4] = "eintr"
	errcode[5] = "eio"
	errcode[6] = "enxio"
	errcode[7] = "e2big"
	errcode[8] = "enoexec"
	errcode[9] = "ebadf"
	errcode[10] = "echild"
	errcode[11] = "edeadlk"
	errcode[12] = "enomem"
	errcode[13] = "eacces"
	errcode[14] = "efault"
	errcode[15] = "enotblk"
	errcode[16] = "ebusy"
	errcode[17] = "eexist"
	errcode[18] = "exdev"
	errcode[19] = "enodev"
	errcode[20] = "enotdir"
	errcode[21] = "eisdir"
	errcode[22] = "einval"
	errcode[23] = "enfile"
	errcode[24] = "emfile"
	errcode[25] = "enotty"
	errcode[26] = "etxtbsy"
	errcode[27] = "efbig"
	errcode[28] = "enospc"
	errcode[29] = "espipe"
	errcode[30] = "erofs"
	errcode[31] = "emlink"
	errcode[32] = "epipe"
	errcode[33] = "edom"
	errcode[34] = "erange"
	errcode[35] = "eagain"
	errcode[36] = "einprogress"
	errcode[37] = "ealready"
	errcode[38] = "enotsock"
	errcode[39] = "edestaddrreq"
	errcode[40] = "emsgsize"
	errcode[41] = "eprototype"
	errcode[42] = "enoprotoopt"
	errcode[43] = "eprotonosupport"
	errcode[44] = "esocktnosupport"
	errcode[45] = "eopnotsupp"
	errcode[46] = "epfnosupport"
	errcode[47] = "eafnosupport"
	errcode[48] = "eaddrinuse"
	errcode[49] = "eaddrnotavail"
	errcode[50] = "enetdown"
	errcode[51] = "enetunreach"
	errcode[52] = "enetreset"
	errcode[53] = "econnaborted"
	errcode[54] = "econnreset"
	errcode[55] = "enobufs"
	errcode[56] = "eisconn"
	errcode[57] = "enotconn"  
	errcode[58] = "eshutdown" 
	errcode[59] = "etoomanyrefs"
	errcode[60] = "etimedout"  
	errcode[61] = "econnrefused" 
	errcode[62] = "eloop"
 	errcode[63] = "enametoolong"
 	errcode[64] = "ehostdown"
 	errcode[65] = "ehostunreach"
 	errcode[66] = "enotempty" 
 	errcode[67] = "eproclim"
 	errcode[68] = "eusers" 
 	errcode[69] = "edquot"
 	errcode[70] = "estale"
	# XXX, but 71 is normally unavailable, recycle 70
	errcode[71] = "estale"			
 	errcode[72] = "ebadrpc"
 	errcode[73] = "erpcmismatch"
 	errcode[74] = "eprogunavail"
 	errcode[75] = "eprogmismatch"
 	errcode[76] = "eprocunavail"
 	errcode[77] = "enolck"
 	errcode[78] = "enosys" 
 	errcode[79] = "eftype"
 	errcode[80] = "eauth"
 	errcode[81] = "eneedauth"
 	errcode[82] = "eipsec"
 	errcode[83] = "enoattr"

	srand()  		# XXX, but awk is not a good PRNG
}

{
	if ((rand() * 10) < myrand) {
		# set the error code
		e = int((rand() * 83) + 1)
		sub(/permit/, "deny\[" errcode[e] "\]")
		print $0
	} else {
		print $0
	}
}

# EOF
